/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import CH.ifa.draw.util.Geom;
import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.EqualsCheck;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareFactory;
import DE.siemens.ad.logo.model.HighResolutionSeconds;
import DE.siemens.ad.logo.model.Hours;
import DE.siemens.ad.logo.model.Minutes;
import DE.siemens.ad.logo.model.ProtectionParameter;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.pdraw.figures.FixedElbowConnection;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class Util {
    private Util() {
    }

    public static final Integer[] asIntegerArray(int[] orgArray) {
        Integer[] resArray = new Integer[orgArray.length];
        for (int i = 0; i < orgArray.length; ++i) {
            resArray[i] = new Integer(orgArray[i]);
        }
        return resArray;
    }

    public static final String asString(String[] array, String delimiter) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            result.append(array[i]).append(delimiter);
        }
        if (result.length() > 0) {
            return result.substring(0, result.length() - 1);
        }
        return "";
    }

    public static final String[] asStringArray(String source, String delimiter) {
        StringTokenizer st = new StringTokenizer(source, delimiter);
        String[] result = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            result[i++] = st.nextToken();
        }
        return result;
    }

    public static String replaceString(String source, String toReplace, String replacement) {
        if (source == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(source);
        int index = -1;
        while ((index = buffer.toString().indexOf(toReplace)) != -1) {
            buffer.replace(index, index + toReplace.length(), replacement);
        }
        return buffer.toString();
    }

    public static Object[] change(Object[] arr, int pos1, int pos2) {
        Object temp = arr[pos1];
        arr[pos1] = arr[pos2];
        arr[pos2] = temp;
        return arr;
    }

    public static String toUppercaseFirstCharacter(String s) {
        StringBuffer buffer = new StringBuffer(s);
        char c = Character.toUpperCase(buffer.charAt(0));
        buffer.setCharAt(0, c);
        return buffer.toString();
    }

    public static boolean isEmptyString(String str) {
        return str == null || str.equals("");
    }

    public static boolean isObjectEqual(Object obj1, Object obj2) {
        if (obj1 == null) {
            if (obj2 == null || obj2.equals("")) {
                return true;
            }
        } else {
            if (obj1.equals("") && (obj2 == null || obj2.equals(""))) {
                return true;
            }
            if (obj1.equals(obj2)) {
                return true;
            }
        }
        return false;
    }

    public static String createMaxSubStringNoWordWrap(String origin, FontMetrics metric, int distance) {
        if (metric.stringWidth(origin) <= distance) {
            return origin;
        }
        String subString = Util.createMaxSubStringWordWrap(origin, metric, distance);
        int index1 = subString.lastIndexOf(32);
        int index2 = subString.lastIndexOf(9);
        if (index1 != -1 || index2 != -1) {
            return subString.substring(0, Math.max(index1, index2));
        }
        return subString;
    }

    public static String createMaxSubStringWordWrap(String origin, FontMetrics metric, int distance) {
        if (metric.stringWidth(origin) <= distance) {
            return origin;
        }
        char[] stringAsChars = origin.toCharArray();
        try {
            int i;
            int length = stringAsChars.length;
            for (i = 1; i <= length && metric.charsWidth(stringAsChars, 0, i) <= distance; ++i) {
            }
            return origin.substring(0, i - 1);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static Vector createSubStrings(String origin, FontMetrics metric, int distance) {
        Vector<String> subStringVector = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(origin, "\n");
        while (tokenizer.hasMoreTokens()) {
            String tokenSubString = tokenizer.nextToken();
            String lineSubString = Util.createMaxSubStringNoWordWrap(tokenSubString, metric, distance);
            while (!tokenSubString.equals(lineSubString)) {
                if (!lineSubString.equals("") && lineSubString.charAt(0) == ' ') {
                    lineSubString = lineSubString.substring(1);
                }
                subStringVector.add(lineSubString);
                int length = tokenSubString.charAt(0) == ' ' ? lineSubString.length() + 1 : lineSubString.length();
                tokenSubString = tokenSubString.substring(length);
                lineSubString = Util.createMaxSubStringNoWordWrap(tokenSubString, metric, distance);
            }
            if (!lineSubString.equals("") && lineSubString.charAt(0) == ' ') {
                lineSubString = lineSubString.substring(1);
            }
            subStringVector.add(lineSubString);
        }
        return subStringVector;
    }

    public static Color getColor(String key, Color defaultColor) {
        int colorB;
        int colorG;
        int colorR;
        try {
            String colorValue = LogoProperties.instance().getProperty(key);
            if (colorValue == null) {
                return defaultColor;
            }
            StringTokenizer tokenizer = new StringTokenizer(colorValue, ",");
            colorR = Integer.parseInt(tokenizer.nextToken());
            colorG = Integer.parseInt(tokenizer.nextToken());
            colorB = Integer.parseInt(tokenizer.nextToken());
        }
        catch (Exception e) {
            return defaultColor;
        }
        return new Color(colorR, colorG, colorB);
    }

    public static final Color getComplementaryColor() {
        return null;
    }

    public static final Color getComplementaryColor(Color c) {
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        hsb[0] = (float)((double)hsb[0] + 0.4);
        if (hsb[0] > 1.0f) {
            hsb[0] = hsb[0] - 1.0f;
        }
        hsb[1] = 1.0f;
        hsb[2] = 0.7f;
        return Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
    }

    public static String getCuttedFilename(File file, int length) {
        String pathname = file.toString();
        if (pathname.length() > length) {
            File parentPath;
            String filename = file.getName();
            if (filename.length() > length - 3) {
                filename = filename.substring(0, length - 4) + "...";
            }
            for (parentPath = file.getParentFile(); parentPath != null && parentPath.toString().length() + filename.length() > length - 3; parentPath = parentPath.getParentFile()) {
            }
            if (parentPath != null && parentPath.equals(file.getParent())) {
                pathname = parentPath + File.separator + filename;
            } else {
                String parentPathString = "";
                if (parentPath != null) {
                    parentPathString = parentPath.toString();
                }
                pathname = parentPathString.lastIndexOf(File.separator) == parentPathString.length() - 1 ? parentPathString + "..." + File.separator + filename : parentPathString + File.separator + "..." + File.separator + filename;
            }
        }
        return pathname;
    }

    public static boolean getDifferences(List source1, List source2, List result) {
        boolean difference = false;
        ArrayList additional1 = new ArrayList();
        ArrayList additional2 = new ArrayList();
        ArrayList equal1 = new ArrayList();
        ArrayList equal2 = new ArrayList();
        source1 = new ArrayList(source1);
        source2 = new ArrayList(source2);
        Iterator e = source1.iterator();
        while (e.hasNext()) {
            Object element = e.next();
            int index = Util.indexOf(source2, (EqualsCheck)element);
            if (index == -1) {
                additional1.add(element);
                difference = true;
                continue;
            }
            equal1.add(element);
            equal2.add(source2.get(index));
            e.remove();
            source2.remove(Util.indexOf(source2, (EqualsCheck)element));
        }
        for (Object element : source2) {
            additional2.add(element);
            difference = true;
        }
        result.add(additional1);
        result.add(additional2);
        result.add(equal1);
        result.add(equal2);
        return difference;
    }

    public static boolean containsEqual(List collection, EqualsCheck element) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!((EqualsCheck)iterator.next()).isEqual(element)) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(List collection, EqualsCheck element) {
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            if (!((EqualsCheck)collection.get(i)).isEqual(element)) continue;
            return i;
        }
        return -1;
    }

    public static void copyFile(File from, File to) throws IOException {
        BufferedInputStream fromStream = new BufferedInputStream(new FileInputStream(from));
        BufferedOutputStream toStream = new BufferedOutputStream(new FileOutputStream(to));
        byte[] buffer = new byte[8192];
        int bytesRead = 0;
        while ((bytesRead = fromStream.read(buffer)) != -1) {
            toStream.write(buffer, 0, bytesRead);
        }
        fromStream.close();
        toStream.close();
        to.setLastModified(from.lastModified());
    }

    public static Color inverseColor(Color inColor) {
        int colorR = 255 - inColor.getRed();
        int colorG = 255 - inColor.getGreen();
        int colorB = 255 - inColor.getBlue();
        return new Color(colorR, colorG, colorB);
    }

    public static Point lastCommonPoint(FixedElbowConnection line1, FixedElbowConnection line2) {
        Point retPoint = null;
        Point nextPointLine1 = null;
        Point nextPointLine2 = null;
        if (line1.pointCount() != 6 || line2.pointCount() != 6) {
            return null;
        }
        for (int i = 4; i > 0; --i) {
            Point actPointLine1 = line1.pointAt(i);
            nextPointLine1 = line1.pointAt(i - 1);
            Point actPointLine2 = line2.pointAt(i);
            nextPointLine2 = line2.pointAt(i - 1);
            if (Geom.lineContainsPoint(actPointLine1.x, actPointLine1.y, nextPointLine1.x, nextPointLine1.y, actPointLine2.x, actPointLine2.y)) {
                retPoint = actPointLine2;
                break;
            }
            if (!Geom.lineContainsPoint(actPointLine2.x, actPointLine2.y, nextPointLine2.x, nextPointLine2.y, actPointLine1.x, actPointLine1.y)) continue;
            retPoint = actPointLine1;
            break;
        }
        return retPoint;
    }

    public static Point lastIdenticalPoint(FixedElbowConnection line1, FixedElbowConnection line2) {
        Enumeration enum1 = line1.points();
        Enumeration enum2 = line2.points();
        Object retPoint = null;
        Point lastPointEnum1 = null;
        Point lastPointEnum2 = null;
        boolean straightLine1 = false;
        boolean straightLine2 = false;
        try {
            if (line1.pointAt((int)1).y == line1.pointAt((int)2).y) {
                straightLine1 = true;
            }
            if (line2.pointAt((int)1).y == line2.pointAt((int)2).y) {
                straightLine2 = true;
            }
            if (straightLine1 || straightLine2) {
                if (straightLine1 && straightLine2) {
                    return null;
                }
                if (straightLine1) {
                    if (line2.pointAt((int)1).x < line1.pointAt((int)3).x) {
                        return line2.pointAt(1);
                    }
                    return line1.pointAt(3);
                }
                if (line1.pointAt((int)1).x < line2.pointAt((int)3).x) {
                    return line1.pointAt(1);
                }
                return line2.pointAt(3);
            }
            Point actPointEnum1 = (Point)enum1.nextElement();
            Point actPointEnum2 = (Point)enum2.nextElement();
            while (actPointEnum1.x == actPointEnum2.x && actPointEnum1.y == actPointEnum2.y && enum1.hasMoreElements()) {
                lastPointEnum1 = actPointEnum1;
                lastPointEnum2 = actPointEnum2;
                actPointEnum1 = (Point)enum1.nextElement();
                actPointEnum2 = (Point)enum2.nextElement();
            }
            retPoint = actPointEnum1.equals(actPointEnum2) ? actPointEnum1 : (lastPointEnum1 == null ? null : (actPointEnum1.x == actPointEnum2.x ? (Geom.lineContainsPoint(actPointEnum1.x, actPointEnum1.y, actPointEnum2.x, actPointEnum2.y, lastPointEnum1.x, lastPointEnum1.y) ? lastPointEnum1 : (actPointEnum1.y < lastPointEnum1.y ? (actPointEnum1.y < actPointEnum2.y ? actPointEnum2 : actPointEnum1) : (actPointEnum1.y < actPointEnum2.y ? actPointEnum1 : actPointEnum2))) : (Geom.lineContainsPoint(actPointEnum1.x, actPointEnum1.y, actPointEnum2.x, actPointEnum2.y, lastPointEnum1.x, lastPointEnum1.y) ? lastPointEnum1 : (actPointEnum1.x > lastPointEnum1.x ? (actPointEnum1.x < actPointEnum2.x ? actPointEnum1 : actPointEnum2) : (actPointEnum1.x < actPointEnum2.x ? actPointEnum2 : actPointEnum1)))));
        }
        catch (Exception e) {
            retPoint = null;
        }
        return retPoint;
    }

    public static final short getHighByte(int a16BitValue) {
        return (short)((a16BitValue & 0xFF00) >> 8);
    }

    public static final short getLowByte(int a16BitValue) {
        return (short)(a16BitValue & 0xFF);
    }

    public static final int getBit(int value, int offset) {
        return value >> offset & 1;
    }

    public static final int makeWord(int lowByte, int highByte) {
        return lowByte |= highByte << 8;
    }

    public static final int makeDoubleWord(int byte0, int byte1, int byte2, int byte3) {
        return (byte3 << 24) + (byte2 << 16) + (byte1 << 8) + byte0;
    }

    public static final int[] asArray(int aIntValue) {
        int[] arr = new int[]{Util.getLowByte(aIntValue), Util.getHighByte(aIntValue), (aIntValue & 0xFF0000) >> 16, (aIntValue & 0xFF000000) >>> 24};
        return arr;
    }

    public static final int makeSignedWord(int highByte, int lowByte) {
        int word = (highByte << 8) + lowByte;
        return word > Short.MAX_VALUE ? word - 65536 : word;
    }

    public static final int makeSignedDoubleWord(int byte0, int byte1, int byte2, int byte3) {
        return (byte0 << 24) + (byte1 << 16) + (byte2 << 8) + byte3;
    }

    public static final String restrictLenght(String stringToRestrict, int restrictLength) {
        StringTokenizer tokenizer = new StringTokenizer(stringToRestrict, "\n");
        StringBuffer restrictedString = new StringBuffer(stringToRestrict.length() + 1);
        boolean loop = tokenizer.hasMoreTokens();
        if (tokenizer.countTokens() > 0) {
            while (loop) {
                String tokenString = tokenizer.nextToken();
                restrictedString.append(Util.getRestrictedString(tokenString, restrictLength));
                loop = tokenizer.hasMoreTokens();
                if (!loop) continue;
                restrictedString.append("\n");
            }
        }
        return restrictedString.toString();
    }

    private static final String getRestrictedString(String stringToRestrict, int restrictLength) {
        StringBuffer ret = new StringBuffer();
        int totalLength = 0;
        for (int i = 0; i < stringToRestrict.length(); ++i) {
            totalLength = stringToRestrict.charAt(i) > '\u00ff' ? (totalLength += 2) : ++totalLength;
            if (totalLength > restrictLength) {
                ret.append("..");
                break;
            }
            ret.append(stringToRestrict.charAt(i));
        }
        return ret.toString();
    }

    public static void sort(Object[] array) {
        for (int i = 1; i < array.length; ++i) {
            int j;
            boolean found = false;
            for (j = i - 1; 0 <= j; --j) {
                if (0 > array[i].toString().compareTo(array[j].toString())) {
                    continue;
                }
                found = true;
                break;
            }
            j = found ? ++j : 0;
            Object o = array[i];
            for (int k = i - 1; k >= j; --k) {
                array[k + 1] = array[k];
            }
            array[j] = o;
        }
    }

    public static LogoDrawing getCurrentDrawing() {
        return (LogoDrawing)Application.getInstance().getMdiManager().getActiveTopLevelView().getModel();
    }

    public static String stripFileExtension(String fileName) {
        int lastDot = fileName.lastIndexOf(".");
        if (lastDot != -1) {
            fileName = fileName.substring(0, lastDot);
        }
        return fileName;
    }

    public static void setEnabledRecursive(Component component, boolean enabled) {
        component.setEnabled(enabled);
        if (component instanceof Container) {
            Component[] components = ((Container)component).getComponents();
            for (int i = 0; i < components.length; ++i) {
                Util.setEnabledRecursive(components[i], enabled);
            }
        }
    }

    public static String getFileExtension(String fileName) {
        return fileName.substring(Util.stripFileExtension(fileName).length());
    }

    public static String[] divideFilenameAndNumber(String filenameWithNumber) {
        String digits = "0123456789";
        StringBuffer numberStringBuffer = new StringBuffer();
        boolean isDigit = true;
        for (int index = filenameWithNumber.length() - 1; index >= 0 && isDigit; --index) {
            char character = filenameWithNumber.charAt(index);
            boolean bl = isDigit = "0123456789".indexOf(character) != -1;
            if (!isDigit) continue;
            numberStringBuffer.insert(0, character);
        }
        return new String[]{filenameWithNumber.substring(0, filenameWithNumber.length() - numberStringBuffer.length()), numberStringBuffer.toString()};
    }

    public static String addLeadingZeros(String numberString, int length) {
        if (numberString.length() < length) {
            numberString = "00000000000000000000".substring(0, length - numberString.length()) + numberString;
        }
        return numberString;
    }

    public static String addLeadingSpaces(String numberString, int length) {
        if (numberString.length() < length) {
            numberString = "                             ".substring(0, length - numberString.length()) + numberString;
        }
        return numberString;
    }

    public static String addTrailingSpaces(String numberString, int length) {
        if (numberString.length() < length) {
            numberString = numberString + "                                        ".substring(0, length - numberString.length());
        }
        return numberString;
    }

    public static String trimRight(String source) {
        int len;
        if (source == null) {
            return null;
        }
        if (source.length() == 0) {
            return source;
        }
        for (len = source.length(); 0 < len && source.charAt(len - 1) <= ' '; --len) {
        }
        return len < source.length() ? source.substring(0, len) : source;
    }

    public static String incrementFilenameNumber(String filename) {
        String filenameWithoutExtension = Util.stripFileExtension(filename);
        String extension = filename.substring(filenameWithoutExtension.length());
        String[] dividedFilename = Util.divideFilenameAndNumber(filenameWithoutExtension);
        int fileNumber = 0;
        if (dividedFilename[1].length() > 0) {
            fileNumber = Integer.parseInt(dividedFilename[1]);
        }
        return dividedFilename[0] + ++fileNumber + extension;
    }

    public static Object deepCopy(Storable source) {
        Storable cloned = null;
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(200);
            StorableOutput so = new StorableOutput(outputStream);
            so.writeStorable(source);
            so.close();
            byte[] clipboard = outputStream.toByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(clipboard);
            StorableInput si = new StorableInput(inputStream);
            cloned = si.readStorable();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cloned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deepCopy(Serializable oldObj) {
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(oldObj);
            oos.flush();
            ByteArrayInputStream bin = new ByteArrayInputStream(bos.toByteArray());
            ois = new ObjectInputStream(bin);
            Object object = ois.readObject();
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            Object var4_6 = null;
            return var4_6;
        }
        finally {
            try {
                oos.close();
                ois.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static int getValueInRange(int min, int max, int value) {
        if (value > max) {
            value = max;
        } else if (value < min) {
            value = min;
        }
        return value;
    }

    public static void exportBlockResources(BufferedWriter writer) throws IOException {
        String delimiter = "\t";
        HardwareFactory hardwareFactory = HardwareFactory.getInstance();
        String[] resourceNames = hardwareFactory.getResourceNames();
        String resourceString = "Hardware\tBlockgruppe\tBlock\tSchutz\t";
        for (int i = 0; i < resourceNames.length; ++i) {
            resourceString = resourceString + resourceNames[i] + "\t";
        }
        System.out.println(resourceString);
        writer.write(resourceString);
        writer.write("\n");
        Collection hardwareNames = hardwareFactory.getNames();
        for (String hardwareName : hardwareNames) {
            Hardware hardware = hardwareFactory.createInstance(hardwareName);
            WiringDiagram wiringDiagram = new WiringDiagram(hardware);
            Vector[] blocks = hardware.getAvailableBlocks();
            for (int i = 0; i < blocks.length; ++i) {
                Iterator blockIterator = blocks[i].iterator();
                Block blockGroup = (Block)blockIterator.next();
                while (blockIterator.hasNext()) {
                    Block block = (Block)blockIterator.next();
                    block.setWiringDiagram(wiringDiagram);
                    if (block.getParameter() != null && block.getParameter().getRemanenceAvailable()) {
                        block.getParameter().getRemanenceObject().setRemanence(true);
                    }
                    int[] memoryResources = block.getMemoryResources(hardware);
                    boolean protection = false;
                    if (block.getParameter() instanceof ProtectionParameter) {
                        protection = true;
                    }
                    resourceString = hardwareName + "\t" + blockGroup + "\t" + block.getName() + "\t" + protection + "\t";
                    for (int j = 0; j < memoryResources.length; ++j) {
                        resourceString = resourceString + memoryResources[j] + "\t";
                    }
                    System.out.println(resourceString);
                    writer.write(resourceString);
                    writer.write("\n");
                }
            }
        }
    }

    public static Rectangle getLarger(int width, int height, Rectangle dest) {
        dest.width = width > dest.width ? width : dest.width;
        dest.height = height > dest.height ? height : dest.height;
        return dest;
    }

    public static void expandArray(int[] array, int count) {
        int[] newArray = new int[array.length + count];
        System.arraycopy(array, 0, newArray, 0, array.length);
        array = newArray;
    }

    public static int toSignedValue(long unsignedValue, int length) {
        byte ret = 0;
        if (length == 8) {
            ret = (byte)unsignedValue;
        } else if (length == 16) {
            ret = (byte)unsignedValue;
        } else if (length == 32) {
            ret = (byte)unsignedValue;
        } else {
            throw new IllegalArgumentException();
        }
        return ret;
    }

    public static int getTimeBase(TimeUnit tu) {
        if (tu.getUnitKey().equals("dialog.timeParameter.hours")) {
            return 3;
        }
        if (tu.getUnitKey().equals("dialog.timeParameter.minutes")) {
            return 2;
        }
        if (tu.getUnitKey().equals("dialog.timeParameter.highResolutionSeconds")) {
            return 1;
        }
        throw new IllegalArgumentException();
    }

    public static void setTimeBase(TimeUnit tu, int value) {
        if (value == 3) {
            tu.convertTo(new Hours());
        } else if (value == 2) {
            tu.convertTo(new Minutes());
        } else if (value == 1) {
            tu.convertTo(new HighResolutionSeconds());
        }
    }
}

